import pandas as pd  
import scipy.stats as stats  
import pickle
  
# Load the dataset  
credit_customers = pd.read_csv("credit_customers.csv")  
  
# Create a new column to identify younger customers (aged 18-35)  
credit_customers['young_customer'] = (credit_customers['age'] >= 18) & (credit_customers['age'] <= 35)  
  
# Filter customers with good credit history  
good_credit_history = credit_customers['credit_history'].isin(['existing paid', 'no credits/all paid', 'all paid'])  
  
# Create groups based on young_customer and good_credit_history  
group1 = credit_customers.loc[credit_customers['young_customer'] & good_credit_history, 'credit_amount']  
group2 = credit_customers.loc[~credit_customers['young_customer'] & good_credit_history, 'credit_amount']  
group3 = credit_customers.loc[credit_customers['young_customer'] & ~good_credit_history, 'credit_amount']  
group4 = credit_customers.loc[~credit_customers['young_customer'] & ~good_credit_history, 'credit_amount']  
  
# Perform ANOVA test  
f_statistic, p_value = stats.f_oneway(group1, group2, group3, group4)  
  
print(f"F-statistic: {f_statistic}, P-value: {p_value}")  
pickle.dump(f_statistic,open("./ref_result/f_statistic.pkl","wb"))
pickle.dump(p_value,open("./ref_result/p_value.pkl","wb"))